// Variables nécessaires à la communication avec la carte Arduino
let delaiMesure = 8000;
let delaiError = 6000;

// Coordonnés du lycée PEM
let InitLat = 47.074062128748594;
let Initlong = 2.4053724646567654;
let zoom = 11;

// Créer et initialiser la carte
let map = L.map('map').setView([InitLat, Initlong], zoom); // lat, long, zoom

// Ajouter un calque de tuiles à la carte
// Source des tuiles : OpenStreetMap
/*L.tileLayer('http://{s}.tile.osm.org/{z}/{x}/{y}.png', {
    attribution: '&copy; <a href="https://osm.org/copyright">OpenStreetMap</a> contributors'
}).addTo(carte);*/

// ou source des tuiles : mapbox (plus complet et meilleur design mais nécessite un jeton)
L.tileLayer('https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token={accessToken}', {
    attribution: 'Map data &copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, Imagery © <a href="https://www.mapbox.com/">Mapbox</a>',
    maxZoom: 19,
    id: 'mapbox/streets-v11',
    tileSize: 512,
    zoomOffset: -1,
    accessToken: 'pk.eyJ1Ijoid2ViZ2UiLCJhIjoiY2wxZ2p2Yno4MHZ0ejNncnRmNzNxZW45MyJ9.xTlsFgrSafNbS3ysCaU7HA'
}).addTo(map);

// Ajouter un marqueur sur la carte
let marker = L.marker([InitLat, Initlong]).addTo(map);

function loadCoordinates() {
    let latitude;
    let longitude;

    $.ajax({
        url: 'scripts/getcoordonnees.php',
        type: 'get',
        dataType: 'json',
        success: function (data) {
            $.each(data, function (entryIndex, entry) {
                // Pour les tests, on souhaite 0 < val0 < 1000 => 47.07970 < latitude < 47.01328
                latitude = -0.0000664 * parseFloat(entry.val0) + 47.07970;
                // Pour les tests, on souhaite 0 < val1 < 780 => 2.199468 < longitude < 2.409102
                longitude = 0.000210 * parseFloat(entry.val1) + 2.199468;

                // Afficher les valeurs numériques
                $('#latitude').html(latitude);
                $('#longitude').html(longitude);

                // Afficher un marqueur sur la carte (objet map)
                map.flyTo([latitude, longitude], 11, {
                    animate: true,
                    duration: 2 // en secondes
                });
                marker = L.marker([latitude, longitude]).addTo(map);
            })
        },
        timeout: delaiError,
        error: function () {
            // pour aller plus loin
        }
    });
}

loadCoordinates(); // premier appel de la fonction

setInterval(function () { // appel de la fonction toutes les delaiMesure ms
    loadCoordinates()
}, delaiMesure);